#include <excpt.h>
#include <windows.h>

#include "stringlist.h"
#include "executive.h"
#include "errors.h"
#include "chat.h"
#include "stdlib.h"
#include "syslog.h"
#include "switches.h"


static CHATDATA   Log;
static char       Buf[ 4096 ];
static BOOL       InitDone = FALSE;


BOOL SysLogInit()
  {
    return InitDone = InitRoom( &Log, 65536 );
  }

void SysLog( char* Str,...)
  {
    va_list p;

    if( ! InitDone ) return;
    LockRoom( &Log );
    _try {
      va_start( p, Str );
      wvsprintf( Buf, Str, p );
      va_end(p);
      AddChatMessage( &Log, Buf );
    }
    _finally {
      UnlockRoom( &Log );
    }
  }

void ExtractSysLog( ULONG Index, STRINGLIST* Result )
  {
    LockRoom( &Log );
    GetChatMessage( &Log, Index, Result );
    UnlockRoom( &Log );
  }

FUNCDEF( GetSysLog )
  {
    ULONG  i = 0;

    if( ! InitDone ) {
      SetReply( Result, ERR_CHAT_INIT, "" );
      return 1;
    }
    if( Params->Count > 1 ) i = Strtoul( Params->Value[1], NULL, 0 );
    SetReply( Result, ERR_NO_ERROR, "" );
    ExtractSysLog( i, Result );
    return 1;
  }
